//------------------------------------------------------------------------------
//
//NAME: Form1.cs
//
//DESCRIPTION: This program has some picture boxes to use as temporary storage
// of images from the clipboard.
//
// Copyright (c) 2021, PineTreeJoe LLC, Joe Bartel - All rights reserved.
// For licensing, see license.txt - Released under MIT license
//
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace Bartel
{
    //--------------------------------------------------------------------------
    //CLASS: Form1
    //--------------------------------------------------------------------------
    public partial class Form1 : Form
    {
        string Command = "none";
        Color Active = Color.HotPink;
        Color NotActive = Color.LightGray;

        //----------------------------------------------------------------------
        //NAME: Form1
        //init the form
        //----------------------------------------------------------------------
        public Form1()
        {
            InitializeComponent();
            Command = "copy";
            ColorButtons();
            btnCopyClipboard.BackColor = Active;
        }
        //----------------------------------------------------------------------
        //NAME: PixBoxClick
        //
        //----------------------------------------------------------------------
        private void PixBoxClick(object sender, EventArgs e)
        {
            PictureBox MyBox = (PictureBox)sender;
            Image MyImage;
            Bitmap PixBits;

            switch (Command)
            {
                case "copy":
                    if (Clipboard.ContainsImage())
                    {
                        MyImage = Clipboard.GetImage();
                        PixBits = new Bitmap(MyImage);
                        MyBox.SizeMode = PictureBoxSizeMode.Zoom;
                        MyBox.Image = PixBits;
                    }
                    else
                    {
                        MessageBox.Show("No Image Available", "PixClip", //Gbls.ProgTitle,
                            MessageBoxButtons.OK, MessageBoxIcon.Information);
                    }
                    break;
                case "put":
                    if ( MyBox.Image != null) 
                    {
                        Clipboard.SetImage (MyBox.Image);
                    }
                    else
                    {
                        MessageBox.Show("No Image Available", "PixClip", //Gbls.ProgTitle,
                            MessageBoxButtons.OK, MessageBoxIcon.Information);
                    }
                    break;
                default:
                    break;
            }
        }
        //----------------------------------------------------------------------
        //NAME: btnCopyClipboard_Click
        //
        //----------------------------------------------------------------------
        private void btnCopyClipboard_Click(object sender, EventArgs e)
        {
            Command = "copy";
            ColorButtons();
            btnCopyClipboard.BackColor = Active;
        }
        //----------------------------------------------------------------------
        //NAME: btnPutInClipboard_Click
        //
        //----------------------------------------------------------------------
        private void btnPutInClipboard_Click(object sender, EventArgs e)
        {
            Command = "put";
            ColorButtons();
            btnPutInClipboard.BackColor = Active;
        }
        //----------------------------------------------------------------------
        //NAME: ColorButtons
        //
        //----------------------------------------------------------------------
        void ColorButtons()
        {
            btnCopyClipboard.BackColor = NotActive;
            btnPutInClipboard.BackColor = NotActive;
        }
    }
}